IF EXISTS (SELECT NAME FROM SYS.TRIGGERS WHERE NAME = 'TRG_RC_CLI_CONV_RC_CLI_AUDIT_INCLUSAO')
	DROP TRIGGER TRG_RC_CLI_CONV_RC_CLI_AUDIT_INCLUSAO;

GO
GO
CREATE TRIGGER [DBO].[TRG_RC_CLI_CONV_RC_CLI_AUDIT_INCLUSAO] ON [DBO].[RC_CLI_CONV_RC_CLI] FOR  INSERT,UPDATE AS
BEGIN
DECLARE @INSERT_COUNT 	INT;
DECLARE @DELETE_COUNT 	INT;
SELECT @INSERT_COUNT = COUNT(*) FROM INSERTED;
SELECT @DELETE_COUNT = COUNT(*) FROM DELETED;


IF @INSERT_COUNT = 0 AND @DELETE_COUNT = 0
	RETURN
IF (@DELETE_COUNT	=  0)
	--TABELA DE CONTROLE DE ALTERACAO DE CONVENIADOS
	INSERT INTO RC_CLI_CONV_RC_CLI_AUDIT (CD_EMP,
										CD_CONV,	
										CD_CLI,	
										VLR_DEB,	
										VLR_CRED,	
										MATRICULA,	
										FLAG_N_EXP_VD_LAY,
										PERC_REC_MIN_CONV,
										PERC_REC_MAX_CONV,
										DT_CAD,
										CD_USU,
										TRANSACAO,
										NM_PROGRAMA,
										IP,
										HOST,
										STS_CRED,
										STS_ATIVO,
										FLAG_CONVENIADO_DEMISSAO,
										ID_CLI_CONV)
		SELECT 
			CD_EMP,
			CD_CONV,	
			CD_CLI,	
			VLR_DEB,	
			VLR_CRED,	
			MATRICULA,	
			FLAG_N_EXP_VD_LAY,
			PERC_REC_MIN_CONV,
			PERC_REC_MAX_CONV,
			GETDATE(),
			ISNULL(CD_USU_ALT,0),
			'I',
			APP_NAME(),
			'',
			HOST_NAME(),
			STS_CRED,
			STS_ATIVO,
			FLAG_CONVENIADO_DEMISSAO,
			ID_CLI_CONV
		FROM 
			INSERTED	
IF (@DELETE_COUNT 	>  0 AND @INSERT_COUNT > 0)
	--TABELA DE CONTROLE DE ALTERACAO DE CONVENIADOS
	INSERT INTO RC_CLI_CONV_RC_CLI_AUDIT (CD_EMP,
										CD_CONV,	
										CD_CLI,	
										VLR_DEB,	
										VLR_CRED,	
										MATRICULA,	
										FLAG_N_EXP_VD_LAY,
										PERC_REC_MIN_CONV,
										PERC_REC_MAX_CONV,
										DT_CAD,
										CD_USU,
										TRANSACAO,
										NM_PROGRAMA,
										IP,
										HOST,
										STS_CRED,
										STS_ATIVO,
										FLAG_CONVENIADO_DEMISSAO,
										ID_CLI_CONV)
		SELECT 
			DELETED.CD_EMP,
			DELETED.CD_CONV,	
			DELETED.CD_CLI,	
			DELETED.VLR_DEB,	
			DELETED.VLR_CRED,	
			DELETED.MATRICULA,	
			DELETED.FLAG_N_EXP_VD_LAY,
			DELETED.PERC_REC_MIN_CONV,
			DELETED.PERC_REC_MAX_CONV,
			GETDATE(),
			ISNULL(DELETED.CD_USU_ALT,0),
			'ANT',
			APP_NAME(),
			'',
			HOST_NAME(),
			DELETED.STS_CRED,
			DELETED.STS_ATIVO,
			DELETED.FLAG_CONVENIADO_DEMISSAO,
			DELETED.ID_CLI_CONV
		FROM 
			DELETED INNER JOIN RC_CLI_CONV_RC_CLI ON
			DELETED.CD_EMP = RC_CLI_CONV_RC_CLI.CD_EMP AND
			DELETED.CD_CLI = RC_CLI_CONV_RC_CLI.CD_CLI AND
			((DELETED.VLR_DEB  + DELETED.VLR_CRED) <> (RC_CLI_CONV_RC_CLI.VLR_DEB  + RC_CLI_CONV_RC_CLI.VLR_CRED) OR
			DELETED.MATRICULA <> RC_CLI_CONV_RC_CLI.MATRICULA)
	--TABELA DE CONTROLE DE ALTERACAO DE CONVENIADOS
	INSERT INTO RC_CLI_CONV_RC_CLI_AUDIT (CD_EMP,
										CD_CONV,	
										CD_CLI,	
										VLR_DEB,	
										VLR_CRED,	
										MATRICULA,	
										FLAG_N_EXP_VD_LAY,
										PERC_REC_MIN_CONV,
										PERC_REC_MAX_CONV,
										DT_CAD,
										CD_USU,
										TRANSACAO,
										NM_PROGRAMA,
										IP,
										HOST,
										STS_CRED,
										STS_ATIVO,
										FLAG_CONVENIADO_DEMISSAO,
										ID_CLI_CONV)
		SELECT 
			INSERTED.CD_EMP,
			INSERTED.CD_CONV,	
			INSERTED.CD_CLI,	
			INSERTED.VLR_DEB,	
			INSERTED.VLR_CRED,	
			INSERTED.MATRICULA,	
			INSERTED.FLAG_N_EXP_VD_LAY,
			INSERTED.PERC_REC_MIN_CONV,
			INSERTED.PERC_REC_MAX_CONV,
			GETDATE(),
			ISNULL(INSERTED.CD_USU_ALT,0),
			'NOVO',
			APP_NAME(),
			'',
			HOST_NAME(),
			INSERTED.STS_CRED,
			INSERTED.STS_ATIVO,
			INSERTED.FLAG_CONVENIADO_DEMISSAO,
			INSERTED.ID_CLI_CONV
		FROM 
			INSERTED 		
END